<?php

namespace TodsApi\Client;

use GuzzleHttp\Client;

use GuzzleHttp\Command\Guzzle\GuzzleClient;
use GuzzleHttp\Command\Guzzle\Description;

/**
 * Class TodsClient
 * @package TodsApi\RestClient
 *
 * @method getGroups() Magic method for getting groups
 * @method getCategories($parameters = []) Magic method for getting categories
 * @method getMarkets($parameters = []) Magic method for getting markets
 * @method getBarData($parameters = []) Magic method for getting bar data
 */
class TodsClient extends GuzzleClient
{
	public static function create($config = [])
	{
	    $definition = json_decode(file_get_contents(__DIR__ . '/../service.json'), true);
	    $description = new Description($definition);
		$client = new Client([
			'headers' => [
				'Content-Type' => 'application/json',
				'Accept'       => 'application/json'
			],
			'auth' => [$config['api_user'], $config['api_pass']],
		]);

		return new static($client, $description, null, null, null, $config);
	}
}