#TODS API Client for Vantagepoint AI

A PHP client for consuming the TODS markets and bar data API. Endpoints defined by services.json.

##Usage
Add the follwing to your composer.json

    "repositories": [{
        "type": "composer",
        "url": "https://repos.hatfield.me"
    }],
    "require": {
      "khatfield/tods-api-client": "*"
    },
      
Create a new Client Instance

    <?php
    
    use TodsApi\Client\TodsClient;
    
    $client = TodsClient::create(['api_user' => $username, 'api_pass' => $password]);

##Groups
Get the instrument groups

    $result = $client->getGroups();
    
##Categories
Get all the categories

    $result = $client->getCategories();
    
Get all categories within a group

    $result = $client->getCategories(['groupid' => $group_id]);
    
Optional Parameters:

- `groupid`: Limits retrieval of categories to a single group

#Markets
Get all the markets

    $result = $client->getMarkets();
    
Get markets within a category

    $result = $client->getMarkets(['categoryid' => $category_id]);
    
Optional Parameters:

- `id`: Pull a single market
- `categoryid`: Limits retrieval of markets to a single category
- `options`: Options for extra data on market retrieval (more documentation to come)

#Bar Data
Get the bar data for a single instrument

    $result = $client->getBarData(['symbolid' => $symbol_id]);
    
Required Parameters:

- `symbolid`: The symbol id (from the markets data)

Optional Parameters:

- `indicators`: A comma-separated list of indicator data to return
- `startdate`: Set the start date for the bar data (defaults to 90 days)

